#ifndef _CMEMPOOL_H
#define _CMEMPOOL_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define _DEBUG_MEMPOOL

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

typedef struct _TAG_ALLOC_POOL {
	int iAddress;
	int iSize;
	bool bFree;
} ALLOCPOOL, *LPALLOCPOOL;

typedef struct _TAG_USER_ALLOC {
	ALLOCPOOL *AllocPool;

	int iAllocated;
	int iAllocIncrement;
} USERALLOC, *LPUSERALLOC;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG_MEMPOOL
#define CMemoryPoolAssert(sExpression, sMsg) \
	if(sExpression)\
	{ \
		char sAssert[2048]; \
		sprintf_s(sAssert, sizeof(sAssert), \
			"A fatal error has occured within the managed memory pool and the application must be ended.\r\n" \
			"\tPlease take note of the following error message and conditions.\t\n\r\n" \
			"Source File: \"%s\"\r\n" \
			"Build Date/Time: %s (%s)\r\nExpression: \"%s\"\r\nLine: %d\r\n\r\n%s", \
			__FILE__, __DATE__, __TIME__, sExpression, __LINE__, sMsg); \
		MessageBox(NULL, sAssert, "Fatal Memory Pool Error!", MB_ICONSTOP | MB_SYSTEMMODAL); \
	}
#else
#define Assert(sExpression, sMsg)
#endif

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class CMemoryPool{

	public:
		#ifdef _DEBUG_MEMPOOL
			bool FreeAll(void);
			int GetMemAllocationCount(void);
			int GetSlotAllocationCount(void);

			bool Free(void *lpMemory);
			bool Destroy(void);
		#else
			void Free(void *lpMemory);
			void Destroy(void);
		#endif

		bool Init(void);
		bool IsDebug(void);
		void *Allocate(const int iSize, const int iCount);
		void *ReAllocate(void *lpMemory, const int iSize);

	protected:
		#ifdef _DEBUG_MEMPOOL
			int FindFreeAllocSlot(void);
			int GetSlotByAddress(int iAddress);
		#endif

	private:
		#ifdef _DEBUG_MEMPOOL
			USERALLOC UserAlloc;
			int iUserAllocs;
		#endif

		CRITICAL_SECTION csMemLock;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
